/*
 * Decompiled with CFR 0.152.
 */
package org.hakanai.jira.plugins.web.action;

import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.DoesNotRequireXsrfCheck;
import javax.inject.Inject;
import org.hakanai.jira.plugins.StatusColor;
import org.hakanai.jira.plugins.service.StatusColorService;
import org.hakanai.jira.plugins.web.action.StatusColorActionSupport;

@SupportedMethods(value={RequestMethod.GET})
@DoesNotRequireXsrfCheck
public class UpdateStatusColorAction
extends StatusColorActionSupport {
    private static final long serialVersionUID = -5693623974390408080L;
    private String color;
    private String statusId;
    private String statusName;

    @Inject
    public UpdateStatusColorAction(StatusColorService statusColorService) {
        super(statusColorService);
    }

    @Override
    public String doDefault() {
        if (!this.hasPermissions()) {
            return "permissionviolation";
        }
        StatusColor statusColor = this.getStatusColorService().getStatusColor(this.getStatusId());
        this.setColor(statusColor.getColor());
        Status status = this.getConstantsManager().getStatus(statusColor.getStatusId());
        if (status != null) {
            this.setStatusName(status.getNameTranslation());
        } else {
            this.setStatusName("");
        }
        return "input";
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doExecute() {
        if (!this.hasPermissions()) {
            this.addErrorMessage(this.getText("status.color.admin.privilege.required"));
            return "error";
        }
        if (this.statusId == null || "".equals(this.statusId)) {
            return this.getRedirect("ViewStatusColors!default.jspa");
        }
        StatusColor statusColor = this.getStatusColorService().getStatusColor(this.getStatusId());
        String newColor = this.color.replaceAll("#", "");
        if (this.hasChanged(statusColor.getColor(), newColor)) {
            statusColor.setColor(newColor);
            this.getStatusColorService().updateStatusColor(statusColor);
        }
        return this.getRedirect("ViewStatusColors!default.jspa");
    }

    private boolean hasChanged(String value1, String value2) {
        return value1 == null ? value2 != null : !value1.equals(value2);
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public String getStatusName() {
        return this.statusName;
    }
}

