/*
 * Decompiled with CFR 0.152.
 */
package org.hakanai.jira.plugins.web.action;

import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.DoesNotRequireXsrfCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import org.hakanai.jira.plugins.StatusColor;
import org.hakanai.jira.plugins.service.StatusColorService;
import org.hakanai.jira.plugins.web.action.StatusColorActionSupport;

@SupportedMethods(value={RequestMethod.GET})
@DoesNotRequireXsrfCheck
public class StatusColorAction
extends StatusColorActionSupport {
    private static final long serialVersionUID = -1998715084990982182L;

    @Inject
    public StatusColorAction(StatusColorService statusColorService) {
        super(statusColorService);
    }

    public Collection<StatusColor> getStatusColors() {
        ArrayList<StatusColor> statusColors = new ArrayList<StatusColor>();
        statusColors.addAll(this.getStatusColorService().getStatusColors());
        this.addTranslatedName(statusColors);
        this.mergeWithUnconfiguredStatus(statusColors);
        return statusColors;
    }

    private void mergeWithUnconfiguredStatus(Collection<StatusColor> statusColors) {
        Collection statuses = this.getConstantsManager().getStatuses();
        for (Status status : statuses) {
            StatusColor statusColor = new StatusColor(status.getId());
            if (statusColors.contains(statusColor)) continue;
            statusColor.setStatusName(status.getNameTranslation());
            statusColors.add(statusColor);
        }
    }

    private void addTranslatedName(Collection<StatusColor> statusColors) {
        Iterator<StatusColor> it = statusColors.iterator();
        while (it.hasNext()) {
            StatusColor statusColor = it.next();
            Status status = this.getConstantsManager().getStatus(statusColor.getStatusId());
            if (status != null) {
                statusColor.setStatusName(status.getNameTranslation());
                continue;
            }
            it.remove();
            this.getStatusColorService().removeStatusColor(statusColor);
        }
    }
}

