/*
 * Decompiled with CFR 0.152.
 */
package org.hakanai.jira.plugins.service;

import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.hakanai.jira.plugins.StatusColor;
import org.hakanai.jira.plugins.service.StatusColorService;

@Named(value="StatusColorService")
public class StatusColorServiceImpl
implements StatusColorService {
    PropertySet entries;
    private Map<String, StatusColor> statusColors = new HashMap<String, StatusColor>();

    @Inject
    public StatusColorServiceImpl() {
        this.loadStatusColors();
    }

    private void loadStatusColors() {
        if (this.statusColors.size() == 0) {
            this.populateWithDefaultData();
        }
    }

    private void populateWithDefaultData() {
        StatusColor openColor = new StatusColor(Integer.toString(1), "FFBFBF");
        StatusColor inProgressColor = new StatusColor(Integer.toString(3), "BFFFE4");
        StatusColor reopenedColor = new StatusColor(Integer.toString(4), "FFBFBF");
        StatusColor resolvedColor = new StatusColor(Integer.toString(5), "FFE6BF");
        StatusColor closedColor = new StatusColor(Integer.toString(6), "e8e8e8");
        this.addStatusColor(openColor);
        this.addStatusColor(inProgressColor);
        this.addStatusColor(reopenedColor);
        this.addStatusColor(resolvedColor);
        this.addStatusColor(closedColor);
    }

    @Override
    public void addStatusColor(StatusColor statusColor) {
        this.statusColors.put(statusColor.getStatusId(), statusColor);
    }

    @Override
    public Collection<StatusColor> getStatusColors() {
        return this.statusColors.values();
    }

    @Override
    public void removeStatusColor(StatusColor statusColor) {
        this.statusColors.remove(statusColor.getStatusId());
    }

    @Override
    public void updateStatusColor(StatusColor statusColor) {
        if (this.statusColors.containsKey(statusColor.getStatusId())) {
            StatusColor stColor = this.statusColors.get(statusColor.getStatusId());
            stColor.setColor(statusColor.getColor());
        }
    }

    @Override
    public StatusColor getStatusColor(String statusId) {
        if (!this.statusColors.containsKey(statusId)) {
            StatusColor color = new StatusColor();
            color.setStatusId(statusId);
            this.addStatusColor(color);
            return color;
        }
        return this.statusColors.get(statusId);
    }
}

