/*
 * Decompiled with CFR 0.152.
 */
package org.hakanai.jira.plugins.fields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.impl.CalculatedCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import org.apache.log4j.Logger;
import org.hakanai.jira.plugins.StatusColor;
import org.hakanai.jira.plugins.service.StatusColorService;

public class StatusColorCFType
extends CalculatedCFType
implements SortableCustomField {
    protected static final Logger log = Logger.getLogger(StatusColorCFType.class);
    private StatusColorService statusColorService;

    public StatusColorCFType(StatusColorService statusColorService) {
        this.statusColorService = statusColorService;
    }

    public String getStringFromSingularObject(Object value) {
        return value != null ? value.toString() : null;
    }

    public Object getSingularObjectFromString(String string) throws FieldValidationException {
        if (string != null) {
            return string;
        }
        return null;
    }

    public Object getValueFromIssue(CustomField field, Issue issue) {
        String statusId = issue.getStatusId();
        String statusNameTranslated = issue.getStatus().getNameTranslation();
        StatusColor statusColor = this.statusColorService.getStatusColor(statusId);
        statusColor.setStatusName(statusNameTranslated);
        statusColor.setIconUrl(issue.getStatus().getIconUrl());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Issue color for : " + issue.getKey() + " and status = " + statusNameTranslated + " is " + statusColor.getColor()));
        }
        return statusColor;
    }

    public int compare(Object customFieldObjectValue1, Object customFieldObjectValue2, FieldConfig fieldConfig) {
        StatusColor color1 = (StatusColor)customFieldObjectValue1;
        StatusColor color2 = (StatusColor)customFieldObjectValue2;
        return color1.getStatusName().compareTo(color2.getStatusName());
    }
}

